/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.websm.user.SetPassword;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.etc.StringVector;
import java.io.File;
import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class UserUtils {
    private static String[] grpName = new String[]{"HSC_Admin", "HSC_Sys_Prog", "HSC_Serv_Rep", "HSC_Operator", "HSC_Adv_Operator", "HSC_Viewer"};
    private static String[] grpDesc = new String[]{"USER_ADMINISTRATOR", "SYSTEM_ADMINISTRATOR", "SERVICE_REPRESENTATIVE", "OPERATOR", "ADVANCED_OPERATOR", "VIEWER"};
    private static String[] grpKeyw = new String[]{"usradmin", "sysadmin", "svcrep", "op", "advop", "viewer"};

    private static boolean isFirstChrNumber(String string) {
        String string2 = string.substring(0, 1);
        try {
            Integer n = new Integer(string2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isAlreadyExist(String string) {
        EExecResult eExecResult = EExec.Exec((String)("grep -c -w " + string + " /etc/passwd | cut -f 1 -d:"));
        if (IDebug.enabled) {
            IDebug.println((String)("grep count of " + string + " is " + eExecResult.stdout));
        }
        if (eExecResult.stdout != null) {
            String string2 = eExecResult.stdout;
            if (!string2.trim().equals("0")) {
                EExecResult eExecResult2 = EExec.Exec((String)("grep  " + string + " /etc/passwd | cut -f 1 -d:"));
                if (eExecResult2.stdout != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(eExecResult2.stdout, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (!string3.trim().equals(string)) continue;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    private static boolean containsInvalidCharacter(String string) {
        char[] cArray = new char[]{'\"'};
        String string2 = new String(cArray);
        int n = 92;
        return string.indexOf(" ") != -1 || string.indexOf(",") != -1 || string.indexOf(":") != -1 || string.indexOf("(") != -1 || string.indexOf(")") != -1 || string.indexOf("[") != -1 || string.indexOf("]") != -1 || string.indexOf("'") != -1 || string.indexOf(string2) != -1 || string.indexOf("|") != -1 || string.indexOf("&") != -1 || string.indexOf(";") != -1 || string.indexOf("$$") != -1 || string.indexOf(n) != -1;
    }

    private static boolean isInvalidLength(String string) {
        return string.length() > 32;
    }

    private static boolean isNoRoleSelected(String string) {
        if (string == null) {
            return true;
        }
        if (string.trim().length() == 0) {
            return true;
        }
        if (string.trim().equals("null")) {
            return true;
        }
        return string.equals("");
    }

    private static String checkServiceRepRole(String[] stringArray, String[] stringArray2) {
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        if (stringArray.length > 0 && stringArray2.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                string = UserUtils.getRoleName(stringArray[n]);
                if (string != null && string.equals("HSC_Serv_Rep")) {
                    if (IDebug.enabled) {
                        IDebug.println((String)("New Role Name : " + string));
                    }
                    bl = true;
                }
                ++n;
            }
            string = "";
            int n2 = 0;
            while (n2 < stringArray2.length) {
                string = UserUtils.getRoleName(stringArray2[n2]);
                if (string != null && string.trim().equals("HSC_Serv_Rep")) {
                    if (IDebug.enabled) {
                        IDebug.println((String)("Old Role : " + stringArray2[n2]));
                    }
                    bl2 = true;
                }
                ++n2;
            }
            if (bl && !bl2) {
                if (IDebug.enabled) {
                    IDebug.println((String)"New is true and Old is false");
                }
                return "add";
            }
            if (!bl && bl2) {
                if (IDebug.enabled) {
                    IDebug.println((String)"New is false & Old is true");
                }
                return "delete";
            }
            return "nothing";
        }
        return "nothing";
    }

    private static boolean isRmcFileExists(String string) {
        try {
            String string2 = "";
            if (string.trim().equals("add")) {
                string2 = "/opt/hsc/bin/rmcadduser";
                File file = new File(string2);
                return file.exists();
            }
            if (string.trim().equals("delete")) {
                string2 = "/opt/hsc/bin/rmcremoveuser";
                File file = new File(string2);
                return file.exists();
            }
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean isInputValid(String string, String string2, String string3, String[] stringArray, String string4, String string5, String[] stringArray2, String string6, Hashtable hashtable) {
        String string7;
        Object object;
        char c;
        String string8 = "";
        boolean bl = false;
        hashtable.put("errorDispose", "false");
        if (stringArray.length > 1) {
            hashtable.put("errorException", "2333");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
            hashtable.put("errorText", "Multiple roles are not allowed, select only one role from the role list");
            return false;
        }
        String string9 = "";
        if (stringArray.length > 0) {
            c = '\u0000';
            while (c < stringArray.length) {
                string9 = UserUtils.getRoleName(stringArray[c]);
                if (string9 != null) {
                    string8 = string8 + string9 + ",";
                    bl = true;
                }
                ++c;
            }
            if (string8.length() > 0) {
                string8 = string8.substring(0, string8.length() - 1);
            }
        }
        if (string.equals("MODIFY") && string6.trim().equals("hscroot")) {
            hashtable.put("errorException", "2332");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
            hashtable.put("errorText", "Sorry, cannot change the HSC special user properties");
            hashtable.put("errorDispose", "true");
            return false;
        }
        if (string2.length() >= 1) {
            String string10;
            c = '\\';
            object = new char[]{c};
            string7 = new String((char[])object);
            char[] cArray = new char[]{'\"'};
            String string11 = new String(cArray);
            if (IDebug.enabled) {
                IDebug.println((String)"Checking for first character in login name..");
            }
            if ((string10 = string2.substring(0, 1).trim()).equals("!") || string10.equals("@") || string10.equals("#") || string10.equals("$") || string10.equals("%") || string10.equals("^") || string10.equals("&") || string10.equals("*") || string10.equals("-") || string10.equals("+") || string10.equals("=") || string10.equals("/") || string10.equals("|") || string10.equals("{") || string10.equals("}") || string10.equals("[") || string10.equals("]") || string10.equals(":") || string10.equals(";") || string10.equals("'") || string10.equals(",") || string10.equals("<") || string10.equals(">") || string10.equals(".") || string10.equals("?") || string10.equals("~") || string10.equals("`") || string10.equals(string11) || string10.equals(string7) || string10.equals("_")) {
                hashtable.put("errorException", "2336");
                hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
                hashtable.put("errorText", "Invalid User Name" + string10);
                return false;
            }
        }
        if (UserUtils.isEmpty(string2)) {
            if (IDebug.enabled) {
                IDebug.println((String)"is Empty");
            }
            hashtable.put("errorException", "2338");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
            hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "LOGIN_NAME_REQUIRED", "Login name is required"));
            return false;
        }
        if (UserUtils.isFirstChrNumber(string2)) {
            hashtable.put("errorException", "2336");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
            hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "INVALID_CHARACTER"));
            return false;
        }
        if (UserUtils.containsInvalidCharacter(string2)) {
            hashtable.put("errorException", "2329");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
            hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "INVALID_CHARACTER"));
            return false;
        }
        if (string.equals("MODIFY") && !string2.equals(string6) && UserUtils.isAlreadyExist(string2.trim())) {
            if (IDebug.enabled) {
                IDebug.println((String)"In alreadyExist check...");
            }
            String string12 = null;
            string12 = HSCResourceBundleUtil.getMessage("UserBundle", "USERNAME", "User Name");
            string12 = string12 + " '" + string2 + "' " + HSCResourceBundleUtil.getMessage("UserBundle", "ALREADY_EXISTS", "Already Exist...");
            hashtable.put("errorException", "232A");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
            hashtable.put("errorText", string12);
            return false;
        }
        if (string.equals("CREATE") && UserUtils.isAlreadyExist(string2.trim())) {
            String string13 = null;
            string13 = HSCResourceBundleUtil.getMessage("UserBundle", "USERNAME", "User Name");
            string13 = string13 + " '" + string2 + "' " + HSCResourceBundleUtil.getMessage("UserBundle", "ALREADY_EXISTS", "Already Exist...");
            hashtable.put("errorException", "232A");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
            hashtable.put("errorText", string13);
            return false;
        }
        if (UserUtils.isInvalidLength(string2)) {
            hashtable.put("errorException", "232B");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "MAX_CHRS"));
            hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "SHOULDNOT_30_CHRS"));
            return false;
        }
        if (UserUtils.isNoRoleSelected(string8)) {
            hashtable.put("errorException", "232C");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "MISSING_VALUE"));
            hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "SELECT_A_ROLE"));
            return false;
        }
        if (string.equals("CREATE")) {
            String string14 = "";
            if (IDebug.enabled) {
                IDebug.println((String)"Copying values");
            }
            hashtable.put("loginName_PROP", string2);
            hashtable.put("fullName_PROP", string3);
            if (string2.equals("hscpe")) {
                string8 = string8 + "," + "HSC_PEMODE";
            }
            hashtable.put("roles_PROP", string8);
            if (bl) {
                if (!UserUtils.isRmcFileExists("add")) {
                    hashtable.put("errorException", "2334");
                    hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
                    hashtable.put("errorText", "Sorry, unable to locate the file 'rmcadduser' in /opt/hsc/bin directory");
                    return false;
                }
                string14 = "adduser";
            } else {
                string14 = "nothing";
            }
            hashtable.put("sfpRmcUser_PROP", string14);
            object = "";
            object = string8.indexOf(",") > 0 ? (Object)string8.substring(0, string8.indexOf(",")) : (Object)string8;
            string7 = "";
            string7 = "/opt/hsc/bin/HSCUserConf -c " + string2;
            if (string3.trim().length() > 0) {
                string7 = string7 + " '" + string3.trim() + "'";
            }
            string7 = string7 + " " + (String)object;
            if (string8 != null) {
                string7 = string7 + " " + string8;
            }
            string7 = !string8.equals("HSC_Admin") ? string7 + " -rmcadd" : string7 + " -rmcnothing";
            hashtable.put("cmd", string7);
        }
        if (string.equals("MODIFY")) {
            String string15 = "";
            if (string2 != null) {
                hashtable.put("loginName_PROP", string2);
            }
            if (string3 != null) {
                if (string3.equals(" ")) {
                    string3 = null;
                } else {
                    hashtable.put("fullName_PROP", string3);
                }
            }
            if (string8 != null && string2.equals("hscpe")) {
                string8 = string8 + "," + "HSC_PEMODE";
            }
            if (string8 != null) {
                hashtable.put("roles_PROP", string8);
            }
            hashtable.put("oldValue", string6);
            string15 = "addUser";
            hashtable.put("sfpRmcUser_PROP", string15);
            object = "/opt/hsc/bin/HSCUserConf -m ";
            if (string2 != null & string3 == null & string8 == null) {
                object = (String)object + " -l " + string2 + " " + string6;
            }
            if (string2 == null & string3 != null & string8 == null) {
                object = (String)object + " -c '" + string3 + "' " + string6;
            }
            if (string2 == null & string3 == null & string8 != null) {
                object = (String)object + " -G " + string8 + " " + string6;
            }
            if (string2 == null & string3 != null & string8 != null) {
                object = (String)object + " -c '" + string3 + "' -G " + string8 + " " + string6;
            }
            if (string2 != null & string3 != null & string8 == null) {
                object = (String)object + " -l " + string2 + " -c '" + string3 + "' " + string6;
            }
            if (string2 != null & string3 != null & string8 != null) {
                object = (String)object + " -l " + string2 + " -c '" + string3 + "' -G " + string8 + " " + string6;
            }
            if (string2 != null & string3 == null & string8 != null) {
                object = (String)object + " -l " + string2 + " -G " + string8 + " " + string6;
            }
            object = !string8.equals("HSC_Admin") ? (Object)((String)object + " -rmcadd") : (Object)((String)object + " -rmcnothing");
            hashtable.put("cmd", object);
        }
        return true;
    }

    private static boolean confirmPassword(String string, String string2) {
        if (string == null || string2 == null || string.trim().length() == 0 || string2.trim().length() == 0) {
            return false;
        }
        if (!UserUtils.isAlreadyExist(string)) {
            return false;
        }
        StringBuffer stringBuffer = UserUtils.parsePassword(string2);
        int n = 0;
        try {
            Process process = Runtime.getRuntime().exec("/opt/hsc/bin/HSCUserConf -o " + string + " " + stringBuffer);
            n = process.waitFor();
        }
        catch (Exception exception) {
            n = -1;
        }
        return n == 0;
    }

    private static StringBuffer parsePassword(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer("");
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '\\') {
                stringBuffer.append(c);
                stringBuffer.append(c);
                stringBuffer.append(c);
            } else if (c == '`' || c == '$' || c == '\"' || c == '\'' || c == ';' || c == '|' || c == '<' || c == '>' || c == '(' || c == ')' || c == '&') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        return stringBuffer;
    }

    public static boolean isPasswordInputValid(String string, String string2, String string3, String string4, String string5, String string6, Hashtable hashtable) {
        hashtable.put("errorShow", "false");
        if (string3 == null || string4 == null || string3.trim().length() <= 0 || string4.trim().length() <= 0) {
            hashtable.put("errorShow", "true");
            hashtable.put("errorException", "2339");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR", "Error"));
            hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "EMPTY_PASSWORD", "Sorry, password cannot be empty"));
            return false;
        }
        int n = UserUtils.getMinPwdLength();
        if (string3.length() < n) {
            hashtable.put("errorShow", "true");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR", "Error"));
            String string7 = MessageFormat.format(HSCResourceBundleUtil.getMessage("UserBundle", "PASSWORD_LENGTH", "BAD PASSWORD: password must be at least {0} characters long"), new Integer(n));
            hashtable.put("errorText", string7);
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        StringBuffer stringBuffer2 = new StringBuffer(string4);
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == '\'' || stringBuffer.charAt(n2) == '\"' || stringBuffer.charAt(n2) == '\\' || stringBuffer.charAt(n2) == '>' || stringBuffer.charAt(n2) == '/' || stringBuffer.charAt(n2) == '$') {
                hashtable.put("errorShow", "true");
                hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR", "Error"));
                hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "INVALID_PASSWORD_CHARACTER", "The password entered contains an invalid character. Passwords cannot contain the following character(s): \" ' \\ / > $. Please retry command."));
                return false;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringBuffer2.length()) {
            if (stringBuffer2.charAt(n3) == '\'' || stringBuffer2.charAt(n3) == '\"' || stringBuffer2.charAt(n3) == '\\' || stringBuffer2.charAt(n3) == '>' || stringBuffer2.charAt(n3) == '/' || stringBuffer2.charAt(n3) == '$') {
                hashtable.put("errorShow", "true");
                hashtable.put("errorException", "2339");
                hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR", "Error"));
                hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "INVALID_PASSWORD_CHARACTER", "The password entered contains an invalid character. Passwords cannot contain the following character(s): ' \" \\ / > $. Please retry command."));
                return false;
            }
            ++n3;
        }
        try {
            if (!string2.equals("hscroot") && !string.equals("CREATE_USER") && string2.trim().length() == 0) {
                hashtable.put("errorException", "2330");
                hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
                hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "BAD_PASSWORD", "Sorry, passwords do not match"));
                return false;
            }
            if (string5 != null && !UserUtils.confirmPassword(string2, string5)) {
                hashtable.put("errorException", "233B");
                hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
                hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "CONFIRM_PASSWORD", "The old password specified for the user was incorrect."));
                return false;
            }
            if (!string3.equals(string4)) {
                hashtable.put("errorShow", "true");
                hashtable.put("errorException", "2330");
                hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
                hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "BAD_PASSWORD", "Sorry, passwords do not match"));
                return false;
            }
            if (string3 == null || string2 == null) {
                hashtable.put("errorException", "2339");
                hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
                hashtable.put("errorText", HSCResourceBundleUtil.getMessage("UserBundle", "EMPTY_PASSWORD", "Password cannot be empty"));
                return false;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            hashtable.put("errorException", "2331");
            hashtable.put("errorTitle", HSCResourceBundleUtil.getMessage("UserBundle", "ERROR"));
            hashtable.put("errorText", throwable.getMessage());
            return false;
        }
        SetPassword setPassword = new SetPassword(string2, string3);
        String string8 = setPassword.encryptPW(string3);
        StringBuffer stringBuffer3 = UserUtils.parsePassword(string8);
        String string9 = "/opt/hsc/bin/HSCUserConf -e " + string2 + " " + stringBuffer3.toString();
        hashtable.put("cmd1", string9);
        if ("hscroot".equals(string2.trim())) {
            string9 = "/opt/hsc/bin/HSCUserConf -s " + string2 + " " + string3;
            hashtable.put("cmd2", string9);
        }
        return true;
    }

    public static String[] getRolesArray(String[] stringArray) {
        return UserUtils.getRolesArray(stringArray, false);
    }

    public static String[] getRolesArray(String[] stringArray, boolean bl) {
        String[] stringArray2 = new String[stringArray.length];
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = UserUtils.getRoleDescription(stringArray[n], bl);
                ++n;
            }
        }
        return stringArray2;
    }

    public static Hashtable getUserProperties(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (string != null) {
            string2 = string.substring(0, string.indexOf(":"));
            string5 = string.substring(string.indexOf(":") + 1, string.length());
            string4 = string5.substring(0, string5.indexOf(":"));
            string3 = string5.substring(string5.indexOf(":") + 1, string5.length());
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("_loginName", string2);
            hashtable.put("_fullName", string3);
            hashtable.put("_id", string4);
            return hashtable;
        }
        return null;
    }

    public static Hashtable getHscGroups(String string) {
        if (string == null) {
            return null;
        }
        EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/getUserList -userroles " + string));
        if (eExecResult.stdout != null) {
            Object object;
            String string2 = eExecResult.stdout;
            String string3 = string2.substring(0, string2.indexOf("~"));
            String string4 = string2.substring(string2.indexOf("~") + 1, string2.length());
            String string5 = string4.substring(0, string4.indexOf("~"));
            String string6 = string4.substring(string4.indexOf("~") + 1, string4.length());
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
            if (stringTokenizer.countTokens() > 0) {
                object = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object[n] = stringTokenizer.nextToken();
                    ++n;
                }
                hashtable.put("roleList", object);
            }
            if (((StringTokenizer)(object = new StringTokenizer(string5, "\n"))).countTokens() > 0) {
                String[] stringArray = new String[((StringTokenizer)object).countTokens()];
                int n = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    stringArray[n] = ((StringTokenizer)object).nextToken();
                    ++n;
                }
                hashtable.put("roleDesc", stringArray);
            }
            hashtable.put("userProp", UserUtils.getUserProperties(string6));
            return hashtable;
        }
        return null;
    }

    public static StringVector getUserList() {
        StringVector stringVector = new StringVector();
        EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/getUserList -list");
        if (eExecResult.rc != 0) {
            return null;
        }
        if (eExecResult.stdout != null) {
            String string = eExecResult.stdout;
            if (string.trim().length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                stringVector.addElement((String)stringTokenizer.nextElement());
            }
        }
        return stringVector;
    }

    public static String getRoleName(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        int n = 0;
        while (n < grpName.length) {
            if (string.equals(HSCResourceBundleUtil.getMessage("UserBundle", grpDesc[n]))) {
                return grpName[n];
            }
            ++n;
        }
        return null;
    }

    public static String getRoleDescription(String string) {
        return UserUtils.getRoleDescription(string, false);
    }

    public static String getRoleDescription(String string, boolean bl) {
        string = string.trim();
        int n = 0;
        while (n < grpName.length) {
            if (string.equals(grpName[n]) || string.equalsIgnoreCase(grpKeyw[n])) {
                if (bl) {
                    return grpKeyw[n];
                }
                return HSCResourceBundleUtil.getMessage("UserBundle", grpDesc[n]);
            }
            ++n;
        }
        return null;
    }

    public static int getPwdExpirationDays(String string) {
        int n;
        block2: {
            n = UserUtils.getMaxPwdExpirationDays();
            EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/HSCUserConf -q pwexp " + string));
            if (eExecResult.rc != 0 || eExecResult.stdout == null) break block2;
            try {
                n = Integer.parseInt(eExecResult.stdout.trim());
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public static int getMinPwdLength() {
        int n;
        block2: {
            n = 7;
            EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/HSCUserConf -q minpwl");
            if (eExecResult.rc != 0 || eExecResult.stdout == null) break block2;
            try {
                n = Integer.parseInt(eExecResult.stdout.trim());
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public static int getMaxPwdExpirationDays() {
        int n;
        block2: {
            n = 180;
            EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/HSCUserConf -q maxpwd");
            if (eExecResult.rc != 0 || eExecResult.stdout == null) break block2;
            try {
                n = Integer.parseInt(eExecResult.stdout.trim());
            }
            catch (Exception exception) {}
        }
        return n;
    }
}

